package main;

import java.awt.EventQueue;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JButton;
import java.awt.FlowLayout;
import javax.swing.JTabbedPane;

import music.Song;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class NewSongDialog extends JDialog {
	private JPanel southPanel;
	private JButton btnOk;
	private JButton btnCancel;
	private JTabbedPane tabbedPane;
	private JPanel panel;
	private JPanel panel_1;
	
	private Song song;
	private NewSongDialog newSongDialog = this;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					NewSongDialog dialog = new NewSongDialog();
					dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
					dialog.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the dialog.
	 */
	public NewSongDialog() {
		setTitle("New song");
		setBounds(100, 100, 450, 300);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);

	}

	public NewSongDialog(JFrame frame, boolean modal) {
		setTitle("New song");
		setBounds(200, 250, 450, 300);
		getContentPane().add(getSouthPanel(), BorderLayout.SOUTH);
		getContentPane().add(getTabbedPane(), BorderLayout.CENTER);
		this.setModal(modal);
	}

	private JPanel getSouthPanel() {
		if (southPanel == null) {
			southPanel = new JPanel();
			FlowLayout flowLayout = (FlowLayout) southPanel.getLayout();
			flowLayout.setAlignment(FlowLayout.RIGHT);
			southPanel.add(getBtnOk());
			southPanel.add(getBtnCancel());
		}
		return southPanel;
	}
	private JButton getBtnOk() {
		if (btnOk == null) {
			btnOk = new JButton("OK");
			btnOk.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					newSongDialog.setVisible(false);
					song = null;
				}
			});
		}
		return btnOk;
	}
	private JButton getBtnCancel() {
		if (btnCancel == null) {
			btnCancel = new JButton("Cancel");
			btnCancel.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					newSongDialog.setVisible(false);
					song = null;
				}
			});
		}
		return btnCancel;
	}
	private JTabbedPane getTabbedPane() {
		if (tabbedPane == null) {
			tabbedPane = new JTabbedPane(JTabbedPane.TOP);
			tabbedPane.addTab("Info", null, getPanel(), null);
			tabbedPane.addTab("Lyrics", null, getPanel_1(), null);
		}
		return tabbedPane;
	}
	private JPanel getPanel() {
		if (panel == null) {
			panel = new JPanel();
		}
		return panel;
	}
	private JPanel getPanel_1() {
		if (panel_1 == null) {
			panel_1 = new JPanel();
		}
		return panel_1;
	}
	
	public Song showDialog() {
		this.setVisible(true);
		dispose();
		return song;
	}
}
